using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using Microsoft.DirectX.DirectPlay;

using DarkStrideToolbox;


namespace DarkStride.StellarLanes.Server
{
	public class frmStartSession : System.Windows.Forms.Form
	{
		#region Properties
		private string m_sSessionName = "";
		#endregion
        
		#region System Stuff
		private System.Windows.Forms.ImageList imgIcons;
		private System.Windows.Forms.Button cmdCancel;
		private System.Windows.Forms.Button cmdStart;
		private System.Windows.Forms.Label lblName;
		private System.Windows.Forms.TextBox txtSessionName;
		private System.ComponentModel.IContainer components;

		public frmStartSession()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(frmStartSession));
			this.imgIcons = new System.Windows.Forms.ImageList(this.components);
			this.cmdCancel = new System.Windows.Forms.Button();
			this.cmdStart = new System.Windows.Forms.Button();
			this.txtSessionName = new System.Windows.Forms.TextBox();
			this.lblName = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// imgIcons
			// 
			this.imgIcons.ImageSize = new System.Drawing.Size(16, 16);
			this.imgIcons.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imgIcons.ImageStream")));
			this.imgIcons.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// cmdCancel
			// 
			this.cmdCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.cmdCancel.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.cmdCancel.ImageAlign = System.Drawing.ContentAlignment.BottomLeft;
			this.cmdCancel.ImageIndex = 0;
			this.cmdCancel.ImageList = this.imgIcons;
			this.cmdCancel.Location = new System.Drawing.Point(8, 36);
			this.cmdCancel.Name = "cmdCancel";
			this.cmdCancel.Size = new System.Drawing.Size(72, 24);
			this.cmdCancel.TabIndex = 9;
			this.cmdCancel.Text = "     &Cancel";
			this.cmdCancel.Click += new System.EventHandler(this.cmdCancel_Click);
			// 
			// cmdStart
			// 
			this.cmdStart.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdStart.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.cmdStart.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.cmdStart.ImageIndex = 1;
			this.cmdStart.ImageList = this.imgIcons;
			this.cmdStart.Location = new System.Drawing.Point(172, 36);
			this.cmdStart.Name = "cmdStart";
			this.cmdStart.Size = new System.Drawing.Size(72, 24);
			this.cmdStart.TabIndex = 8;
			this.cmdStart.Text = "    &Start";
			this.cmdStart.Click += new System.EventHandler(this.cmdStart_Click);
			// 
			// txtSessionName
			// 
			this.txtSessionName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSessionName.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.txtSessionName.Location = new System.Drawing.Point(64, 8);
			this.txtSessionName.Name = "txtSessionName";
			this.txtSessionName.Size = new System.Drawing.Size(176, 20);
			this.txtSessionName.TabIndex = 14;
			this.txtSessionName.Text = "";
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(8, 8);
			this.lblName.Name = "lblName";
			this.lblName.Size = new System.Drawing.Size(56, 16);
			this.lblName.TabIndex = 15;
			this.lblName.Text = "Name:";
			this.lblName.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// frmStartSession
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(248, 69);
			this.ControlBox = false;
			this.Controls.Add(this.txtSessionName);
			this.Controls.Add(this.lblName);
			this.Controls.Add(this.cmdCancel);
			this.Controls.Add(this.cmdStart);
			this.Name = "frmStartSession";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Start New App Session";
			this.Load += new System.EventHandler(this.frmStart_Load);
			this.ResumeLayout(false);

		}
		#endregion
		#endregion


		private void frmStart_Load(object sender, System.EventArgs e)
		{
			txtSessionName.Text = m_sSessionName;
		}


		private void cmdStart_Click(object sender, System.EventArgs e)
		{
			//Save the name
			if( txtSessionName.Text.Length > 0 )
			{
				m_sSessionName = txtSessionName.Text;
			}
			else
			{
				MessageBox.Show( "Please enter a valid server name." );
				return;
			}

			//Tell them we said yes
			this.DialogResult = System.Windows.Forms.DialogResult.Yes;
		}
		private void cmdCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = System.Windows.Forms.DialogResult.No;
		}



		#region Properties
		public string SessionName
		{
			get
			{
				return( m_sSessionName );
			}
			set
			{
				m_sSessionName = value;
			}
		}
		#endregion
	}
}
